from contextlib import redirect_stdout
import io, sys

DEBUG = False

targetTestFile = "CountConsecutiveChars.py"

def main():
    # Counts successful tests
    correctCount = 0

    submittedCode = importFileContents(targetTestFile)
    testCases = importTestCases(targetTestFile)
    expectedOutput = setExpectedOutputs(targetTestFile)

    # Checks to see if the "ExpectedOutput.txt" file has been greatly tampered
    # with and no longer matches with the testCases
    if len(testCases) > len(expectedOutput):
        print("ERROR: EXPECTED OUTPUT MODIFIED")
        exit()

    print("Testing Program: " + targetTestFile)
    printLineBreak()
    # Runs multiple tests and keep track of how many were successful
    for i in range(len(testCases)):
        if runTest(submittedCode, testCases[i], expectedOutput[i]):
            correctCount += 1
        else:
            print("Test #", i+1)
            # print("TEST CASE:\n" + testCases[i], end='')
            print("Test", i+1, "failed")

    printLineBreak()
    print("Passed ", correctCount, "/", len(testCases), " tests: ", str((correctCount/len(testCases)) *100) + "%", sep='')
    printLineBreak()

    suspendCmdPromptClosure()

# Prints a line break with default args
def printLineBreak(char = '-', length = 50):
    print(char*length)

# Pulls expected outputs from the "ExpectedOutput.txt" file - Based on specs example
def setExpectedOutputs(programName):
    content = importFileContents(programName.replace(".py", "") + "_ExpectedOutput.txt")
    # Tokenizes the expected outputs
    expectedOutputs = content.split("<***>")
    # Testing the tokenizing
    if DEBUG:
        for val in expectedOutputs:
            print(val)
            print("\n")

    # Returns a list with the expected outputs for each test case
    return expectedOutputs

# Runs the test: Takes the code, simulated input, and expected result as args
def runTest(code, simInput, expected):
    # Save original stdin pointer
    saved_stdin = sys.stdin
    # Change stdin pointer to simulate input
    sys.stdin = io.StringIO(simInput)

    # Executes the test code and redirects the output to the answer variable
    answer = io.StringIO()

    # Attempts to execute the imported code, if an error occurs, it is printed
    try:
        with redirect_stdout(answer):
            exec(code)
    except Exception as e:
        printLineBreak()
        print("ERROR WHILE EXECUTING:\n" + str(e) + "\n")

    # Reset stdin
    sys.stdin = saved_stdin

    if DEBUG:
        print("***ANS:\n", answer.getvalue(), sep='', end='')
        print("***EXP:\n", expected, sep='', end='')

    # Check answer versus expected
    if answer.getvalue() != expected:
        if DEBUG == False:
            print("Test case:\n" + simInput + "\n")
            print("***Actual Output:\n", answer.getvalue(), sep='', end='')
            print("\n", end='')
            print("***Expected Output:\n", expected, sep='', end='')
        return False
    else:
        return True

def importFileContents(fileName):
    try:
        with open(fileName) as f:
            content = ""
            for line in f:
                content += line
    except FileNotFoundError:
        # Checks to see if the file is named appropriately
        print("File \"" + fileName + "\" Not Found.\nMake sure it exists and/or is named correctly.")
        suspendCmdPromptClosure()
        exit()
    return content

def importTestCases(programName):
    content = ''

    with open(programName.replace(".py", "") + "_TestCases.txt") as f:
        for line in f:
            if "##" in line:
                continue
            content += line

        cases = content.split("<***>\n")

    return cases

# Keeps the cmd prompt open until return is pressed (in case the program is executed from a double click)
def suspendCmdPromptClosure():
    input("\nPress RETURN or ENTER to exit program\n")


main()
